//=============================================================================
// Ammo23mm.
//=============================================================================
class AmmoStar extends DeusExAmmo;

#exec TEXTURE IMPORT NAME="AmmoStar" FILE="C:\DeusEx\MarkistanCity\Textures\AmmoStar.pcx" GROUP=Skins

//
// SimUseAmmo - Spawns shell casings client side
//
simulated function bool SimUseAmmo()
{
	local vector offset, tempvec, X, Y, Z;
	local StarCasing shell;

	if ( AmmoAmount > 0 )
	{
		GetAxes(Pawn(Owner).ViewRotation, X, Y, Z);
		offset = Owner.CollisionRadius * X + 0.3 * Owner.CollisionRadius * Y;
		tempvec = 0.8 * Owner.CollisionHeight * Z;
		offset.Z += tempvec.Z;

		shell = spawn(class'StarCasing',,, Owner.Location + offset);
		shell.RemoteRole = ROLE_None;

		if (shell != None)
		{
			shell.Velocity = (FRand()*20+90) * Y + (10-FRand()*20) * X;
			shell.Velocity.Z = 0;
		}
		return True;
	}
	return False;
}

function bool UseAmmo(int AmountNeeded)
{
	local vector offset, tempvec, X, Y, Z;
	local StarCasing shell;

	if (Super.UseAmmo(AmountNeeded))
	{
		GetAxes(Pawn(Owner).ViewRotation, X, Y, Z);
		offset = Owner.CollisionRadius * X + 0.3 * Owner.CollisionRadius * Y;
		tempvec = 0.8 * Owner.CollisionHeight * Z;
		offset.Z += tempvec.Z;
      if ( DeusExMPGame(Level.Game) != None )
      {
			if ( Level.NetMode == NM_ListenServer )
			{
	         shell = spawn(class'StarCasing',,, Owner.Location + offset);
				shell.RemoteRole = ROLE_None;
			}
			else
	         shell = None;
      }
      else
      {
         shell = spawn(class'StarCasing',,, Owner.Location + offset);
      }
		if (shell != None)
		{
			shell.Velocity = (FRand()*20+90) * Y + (10-FRand()*20) * X;
			shell.Velocity.Z = 0;
		}
		return True;
	}
	return False;
}

defaultproperties
{
     bShowInfo=True
     AmmoAmount=10
     MaxAmmo=80
     ItemName="23mm Star Flash-Shells"
     ItemArticle="some"
     PickupViewMesh=LodMesh'DeusExItems.AmmoShell'
     Icon=Texture'DeusExUI.Icons.BeltIconAmmoSabot'
     largeIcon=Texture'DeusExUI.Icons.LargeIconAmmoSabot'
     largeIconWidth=34
     largeIconHeight=45
     Description="Specialized 23mm STAR Flash-bang rounds. Made specifically for riot control and is not very effective outside of non-lethal use."
     beltDescription="FLASH"
     Mesh=LodMesh'DeusExItems.AmmoShell'
     Skin=Texture'AmmoStar'
     CollisionRadius=9.300000
     CollisionHeight=10.210000
     bCollideActors=True
}
